package gov.va.med.mhv.usermgmt.data.repository;


import gov.va.med.mhv.usermgmt.data.model.DirectMessage;

import java.sql.Timestamp;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface DirectMessageRepository extends JpaRepository<DirectMessage, Long> {

	
	/**
	 *
	 * @param userProfileId
	 * @param createdDate
	 * @return
	 */
	@Query("Select dm from DirectMessage dm where dm.userProfileId = :userProfileId order by dm.createdDate desc")
	List<DirectMessage> getByUserProfileId(@Param("userProfileId") Long userProfileId);
	
	/**
	 *
	 * @param userProfileId
	 * @param createdDate
	 * @return
	 */
	@Query("Select dm from DirectMessage dm where dm.userProfileId = :userProfileId and dm.createdDate > :createdDate order by dm.createdDate desc")
	List <DirectMessage>getByUserProfileIdAndCreatedDate(@Param("userProfileId") Long userProfileId, @Param("createdDate") Timestamp createdDate);
	
	
	@Query("Select dm from DirectMessage dm where dm.userProfileId = :userProfileId and dm.directMessageStatus = :directMessageStatus")
	List<DirectMessage> getByUserProfileIdAndDirectMessageStatus(Long userProfileId, String directMessageStatus);
	
	/**
	 *
	 * @param directStatus
	 * @return
	 */
	
	@Query("Select dm from DirectMessage dm where dm.directMessageStatus = :directMessageStatus")
	List <DirectMessage> getByDirectMessageStatus(@Param("directMessageStatus") String directMessageStatus);
}
